import { world } from "@minecraft/server";
import { ActionFormData } from "@minecraft/server-ui";


world.afterEvents.playerInteractWithEntity.subscribe(event => {
    const { player, target } = event;
    if (!target || target.typeId !== "hivehub:npc_postbox") return;

    showCreditsUI(player);
    player.runCommandAsync("playsound note.xylophone @s");
});


world.afterEvents.entityHitEntity.subscribe(event => {
    const { damagingEntity, hitEntity } = event;
    if (!(damagingEntity?.typeId === "minecraft:player")) return;
    if (!hitEntity || hitEntity.typeId !== "hivehub:npc_postbox") return;

    showCreditsUI(damagingEntity);
    damagingEntity.runCommandAsync("playsound note.xylophone @s");
});

function showCreditsUI(player) {
    new ActionFormData()
        .title("§lServer Info")
            .button('§9How to play\n§r§7[ Click to View ]', "textures/ui/blue_info_glyph")
            .button('§cRules\n§r§7[ Click to View ]', "textures/ui/ErrorGlyph")
            .button('§gCredits\n§r§7[ Click to View ]', "textures/ui/permissions_op_crown")
            .button('§eChangelog\n§r§7[ Click to View ]', "textures/items/book_writable")
            .show(player).then(r => {
                if (r.selection == 0) howtoplay(player)
                if (r.selection == 1) rules(player)
                if (r.selection == 2) Credits(player)
                if (r.selection == 3) changelog(player)
            })
    }
    function changelog(player) {
    new ActionFormData()
        .title("§lChangelog")
        .body(
            `§l§nCHANGELOG§r\n` +
            `§r§eCurrent Version: §cBETA 4.0\n\n` +

            `§l§aNew Features:\n` +
            `§r§7• Totally a new lobby (big lobby added)\n` +
            `§7• Added RANKS NPC in the lobby with new rank system\n` +
            `§7• Warrior rank: Strength V and Resistance III permanently\n` +
            `§7• Healer rank: Regeneration V permanently\n` +
            `§7• Miner rank: Haste V permanently\n` +
            `§7• New PvP area added (coming fully soon)\n` +
            `§7• New PvE area in cave-like dungeons (now script-based with custom AI & loot tables)\n` +
            `§7• Shulker Box Place added\n` +
            `§7• Relaxing Park added\n` +
            `§7• Relaxing Place removed (expected to return in a future update)\n` +
            `§7• New Admin Shop area\n` +
            `§7• New cave-like Mining Area 2\n` +
            `§7• Improved Enchanting Room and Smelting Room\n` +
            `§7• New NPCs added with improved functionality\n\n` +

            `§l§eImprovements:\n` +
            `§r§7• Parkour checkpoint now uses dynamic properties and has improvements\n` +
            `§7• BowWars slightly improved\n` +
            `§7• BlockDrop system fully changed, now matches Hive behavior using dynamic properties\n` +
            `§7• Server GUI improved with new player info buttons\n` +
            `§7• Scoreboard display system improved (you can now hide/unhide it via server settings)\n` +
            `§7• Gamerules, weather, and time now saved properly using dynamic properties\n` +
            `§7• Kills and deaths now count properly even with fire aspect/flame\n` +
            `§7• Slight changes in School and Neighborhood places\n` +
            `§7• Slightly improved VIP Zone\n\n` +

            `§l§cFixes:\n` +
            `§r§7• End reward issue fixed (requires dragon kill now, script-based)\n` +
            `§7• Land temporarily unavailable due to bugs (expected back in next update)\n` +
            `§7• Admin’s OP shop removed, replaced with OP Enchanter NPC in mining area\n` +
            `§7• Several bug fixes\n\n` +

            `§l§aThanks for playing and enjoy BETA 4.0!\n\n` +

            `§8§m───────────────────────────────§r\n\n` +

            `§l§6Previous Update: BETA 3.0\n\n` +

            `§l§aNew Features:\n` +
            `§r§7• Lobby updated\n` +
            `§7• SkyWars lobby added\n\n` +

            `§l§eImprovements:\n` +
            `§r§7• Skyblock mine expanded to 3×3\n` +
            `§7• Renamed mining areas\n` +
            `§7• Fixed bank manager teleportation\n` +
            `§7• Land improvements\n` +
            `§7• New PvE arena + system improvements\n` +
            `§7• Trees added to Relaxing Park border\n` +
            `§7• PvP system enhancements\n` +
            `§7• Selling is now 5× faster\n` +
            `§7• Server menu improved\n` +
            `§7• AFK detection added in selling room\n` +
            `§7• Shop and sell prices adjusted\n\n` +

            `§l§cFixes:\n` +
            `§r§7• Removed information popup\n` +
            `§7• General bug fixes\n\n` +

            `§l§aThanks for playing and enjoy BETA 3.0!`
        )
        .button('§l§cBack', "textures/ui/arrow_left")
        .show(player).then(r => {
            if (r.selection === 0) showCreditsUI(player);
        });
}
    
    function rules(player) {
    new ActionFormData()
        .title('§l§cServer Rules')
        .body(
            `§l§cMUST READ - SERVER RULES\n` +
            `§r§7Violating any of these rules may result in §4ban, mute, or restrictions.\n\n` +

            `§l§eRule 1: §r§fCrafting Tables are §cNOT allowed§f.\n` +
            `§7Use only the server's official systems to obtain items.\n\n` +

            `§l§eRule 2: §r§fNo §cgriefing§f or §chacking§f.\n` +
            `§7Cheating or destroying others' builds = §4instant ban§7.\n\n` +

            `§l§eRule 3: §r§fNo §ctoxic behavior§f.\n` +
            `§7Spamming, trolling, and offensive language are punishable.\n\n` +

            `§l§eRule 4: §r§fAlways §brespect§f others.\n` +
            `§7Be kind, no bullying or hate speech.\n\n` +

            `§l§eRule 5: §r§fNo §cstealing§f.\n` +
            `§7Do not take items from other players or chests without permission.\n\n` +

            `§l§eRule 6: §r§fDo not exploit bugs or glitches.\n` +
            `§7Report any exploits to staff immediately.\n\n` +

            `§l§eRule 7: §r§fFollow staff instructions at all times.\n` +
            `§7Disrespecting staff can lead to a ban.\n\n` +

            `§l§eRule 8: §r§fNo alt accounts to bypass bans or gain unfair advantages.\n\n` +

            `§r§cThese rules apply everywhere — §lno exceptions.§r\n`
        )
        .button('§l§cBack', 'textures/ui/arrow_left')
        .show(player).then(r => {
            if (r.selection === 0) showCreditsUI(player);
        });
}

    function howtoplay(player) {
    new ActionFormData()
        .title("§lHow to play")
        .body(
            `§l§n§bHOW TO PLAY§r\n\n` +

            `§r§7Welcome to the world of §aMining Simulator§7!\n` +
            `§7Here, your mission is to become the §6§lRichest Miner Alive!§r\n\n` +

            `§l§6▶ STARTING OFF ◀§r\n` +
            `§r• Get a free §2Wooden Pickaxe §rfrom §aThe Merchant§r.\n` +
            `• Head into the §aMining Area§r and start digging!\n` +
            `• Collect valuable ores: §7Cobblestone§r, §8Coal§r, §fIron§r, §6Gold§r,\n  §1Lapis§r, §4Redstone§r, §9Flint§r, §8Copper§r, §2Emerald§r,\n  §bDiamond§r, §0Obsidian§r, and §5Ancient Debris§r.\n\n` +

            `§l§e▶ SELL & UPGRADE ◀§r\n` +
            `§r• Sell ores to the §eMineral Merchant §rfor money.\n` +
            `• Use your earnings to §aUpgrade Tools§r, §bBuy Armor§r,\n  §dPotions§r, §cFood§r, and more in the §aThe Merchant§r.\n\n` +

            `§l§3▶ MINI GAMES ◀§r\n` +
            `§r§d• PVP     • PVE     • Parkour\n` +
            `• BlockDrop     • SkyWars     • BowWars\n` +
            `• §5The End §7- §rKill the Ender Dragon for special rewards\n` +
            `§8(More mini-games coming soon!)\n\n` +

            `§l§9▶ PLACES TO EXPLORE ◀§r\n` +
            `§7• §fGarbage Bank§8 – Retrieve cleared items\n` +
            `§7• §fShulker Box Area§8 – Organize your gear\n` +
            `§7• §fRelaxing Park§8 – Take a break with friends\n` +
            `§7• §fSchool & Neighborhood§8 – Explore secrets\n` +
            `§7• §fThe Land§8 – Buy land and build your dream base\n` +
            `§7• §6VIP Zone§8 – Exclusive area for VIP players\n\n` +

            `§l§aReady to begin your journey? Let’s dig in!`
        )
        .button('§l§cBack', "textures/ui/arrow_left")
        .show(player).then(r => {
            if (r.selection === 0) showCreditsUI(player);
        });
}

    function Credits(player) {
    new ActionFormData()
        .title("§lCredits")
        .body(
            // Header
            `§l§nCREDITS§r\n\n` +

            // Developer section
            `§l§dDeveloper & Architect:\n` +
            `§r §bFly Sakib\n\n` +

            // Tools & Technology
            `§l§aBuilt With:\n` +
            `§r §7• Minecraft Bedrock Scripting API\n` +
            ` §7• Custom Behavior Packs\n` +
            ` §7• Hundreds of Command Blocks\n` +
            ` §7• Creative Vision & Late Nights\n\n` +

            // Special Thanks
            `§l§eSpecial Thanks To:\n` +
            `§r §bCommunity Testers & Players\n` +
            ` §bFeedback Contributors\n` +
            ` §bFriends & Family\n\n` +

            // Acknowledgments
            `§l§6Acknowledgments:\n` +
            `§r §7- Everyone who offered ideas\n` +
            ` §7- Those patient with testing phases\n` +
            ` §7- Anyone who supported the project\n\n` +

            // Final note
            `§l§cThank You For Playing!\n` +
            `§r§bYour adventures power this world.\n` +
            `§r§bKeep mining, exploring, and having fun!`
        )
        .button('§l§cBack', "textures/ui/arrow_left")
        .show(player).then(r => {
            if (r.selection === 0) showCreditsUI(player);
        });
}